<?php

   // This script checks for the useability of cookies.

   // The check consists of two phases:
   //
   //    1.  send a set-cookie request
   //        reload current page
   //    2.  check whether set-cookie request was successful
   //        perform action based on previous check

   // phase 1 or 2?

   if(empty($check)) {

      // Phase 1. Set-cookie/redirect to this page
      $page = "$PHP_SELF?check=1";
      header("Location: $page");
      setcookie("testcookie", "1");
   } else {
    
      // Phase 2. Check whether the test cookie is set
      if(empty($testcookie)) {   // Cookie is not set
         echo "Could not set test cookie. Please enable cookies.";
      } else {
         // Cookie is set. You can redirect to your main page here,
         // print the main menu, etc. For example:
         // header("Location: mainpage.php");
         echo "Your browser supports cookies.";
      }
   }
?>
